/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.v1_7;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.com.mojang.authlib.GameProfile;
import net.minecraft.util.com.mojang.authlib.properties.Property;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.api.reflection.exception.ReflectionException;
import net.skinsrestorer.v1_7.BukkitLegacyProperty;
import org.bukkit.entity.Player;

public class BukkitLegacyPropertyApplier {
    public static void applyProperty(Player player, IProperty property) {
        try {
            GameProfile profile = BukkitLegacyPropertyApplier.getGameProfile(player);
            profile.getProperties().removeAll((Object)"textures");
            profile.getProperties().put((Object)"textures", (Object)((Property)property.getHandle()));
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
    }

    public static GameProfile getGameProfile(Player player) throws ReflectionException {
        Object ep = ReflectionUtil.invokeMethod(player.getClass(), player, "getHandle");
        return (GameProfile)ReflectionUtil.invokeMethod(ep.getClass(), ep, "getProfile");
    }

    public static Map<String, Collection<IProperty>> getPlayerProperties(Player player) throws ReflectionException {
        Map getGameProfileProperties = BukkitLegacyPropertyApplier.getGameProfile(player).getProperties().asMap();
        HashMap<String, Collection<IProperty>> properties = new HashMap<String, Collection<IProperty>>();
        for (Map.Entry entry : getGameProfileProperties.entrySet()) {
            ArrayList<BukkitLegacyProperty> list = new ArrayList<BukkitLegacyProperty>();
            for (Property property : (Collection)entry.getValue()) {
                list.add(new BukkitLegacyProperty(property.getName(), property.getValue(), property.getSignature()));
            }
            properties.put((String)entry.getKey(), list);
        }
        return properties;
    }
}

